/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mennomax.astikorcarts.client.renderer.entity.model.EasyMeshBuilder;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;

public abstract class CartModel<T extends AbstractDrawnEntity>
extends EntityModel<T> {
    protected final ModelPart body;
    protected final ModelPart leftWheel;
    protected final ModelPart rightWheel;

    protected CartModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.leftWheel = root.m_171324_("leftWheel");
        this.rightWheel = root.m_171324_("rightWheel");
    }

    public ModelPart getBody() {
        return this.body;
    }

    public ModelPart getWheel() {
        return this.rightWheel;
    }

    public void m_7695_(PoseStack stack, VertexConsumer buf, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftWheel.m_104306_(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightWheel.m_104306_(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        float rot;
        this.body.f_104203_ = (float)Math.toRadians(pitch);
        this.rightWheel.f_104203_ = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(0) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(0) * (double)delta);
        this.leftWheel.f_104203_ = (float)(((AbstractDrawnEntity)((Object)entity)).getWheelRotation(1) + ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(1) * (double)delta);
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            rot = (float)Math.toRadians(Mth.m_14031_((float)time) * time * damage / 40.0f * (float)(-((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
        } else {
            rot = 0.0f;
        }
        this.rightWheel.f_104205_ = rot;
        this.leftWheel.f_104205_ = rot;
    }

    public static MeshDefinition createDefinition() {
        MeshDefinition def = new MeshDefinition();
        EasyMeshBuilder leftWheel = new EasyMeshBuilder("leftWheel", 46, 60);
        leftWheel.setRotationPoint(14.5f, -11.0f, 1.0f);
        leftWheel.addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(-2.0f, -4.5f, 9.86f, 2.0f, 9.0f, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(-1.5f, 1.0f, -0.5f, 1.0f, 9.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            leftWheel.addChild(spoke);
        }
        leftWheel.build(def.m_171576_());
        EasyMeshBuilder rightWheel = new EasyMeshBuilder("rightWheel", 46, 60);
        rightWheel.setRotationPoint(-14.5f, -11.0f, 1.0f);
        rightWheel.addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        for (int i = 0; i < 8; ++i) {
            EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 54);
            rim.addBox(0.0f, -4.5f, 9.86f, 2.0f, 9.0f, 1.0f);
            rim.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(rim);
            EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 54);
            spoke.addBox(0.5f, 1.0f, -0.5f, 1.0f, 9.0f, 1.0f);
            spoke.xRot = (float)i * (float)Math.PI / 4.0f;
            rightWheel.addChild(spoke);
        }
        rightWheel.build(def.m_171576_());
        return def;
    }

    public static EasyMeshBuilder createBody() {
        EasyMeshBuilder body = new EasyMeshBuilder("body");
        body.setRotationPoint(0.0f, -11.0f, 1.0f);
        return body;
    }
}

